// SampleDlg.h : header file
//

#if !defined(AFX_SAMPLEDLG_H__BC051E1F_C5E9_4480_B240_367499667ED1__INCLUDED_)
#define AFX_SAMPLEDLG_H__BC051E1F_C5E9_4480_B240_367499667ED1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "pssdk.h"
#include "psproperty.h"

#include "PropertyPage.h"

/////////////////////////////////////////////////////////////////////////////
// Helper callback structures

struct SHOOT_COMPLETED_PARAM	// used by callback function pfnShootCompletedCallback
{
	SHOOT_COMPLETED_PARAM() : session (0), strSavePath (), hwndDlg (NULL) { }
	SHOOT_COMPLETED_PARAM(const SHOOT_COMPLETED_PARAM & src) : 
		session (src.session), strSavePath (src.strSavePath), hwndDlg (src.hwndDlg) { }

	PSSessionHandle	session;
	CString			strSavePath;
	HWND			hwndDlg;
};

struct DOWNLOAD_COMPLETED_PARAM	// used by callback function pfnDownloadCompletedCallback
{
	DOWNLOAD_COMPLETED_PARAM () : hwndDlg (NULL) { }
	DOWNLOAD_COMPLETED_PARAM (const DOWNLOAD_COMPLETED_PARAM & src) : hwndDlg (src.hwndDlg) { }

	HWND	hwndDlg;
};

struct PREVIEW_FRAME_PARAM 	// used by callback function pfnNewPreviewFrameCallback
{
	PREVIEW_FRAME_PARAM () : hwndDlg (NULL) { }
	PREVIEW_FRAME_PARAM (const PREVIEW_FRAME_PARAM & src) : hwndDlg (src.hwndDlg) { }

	HWND	hwndDlg;
};

struct CAMERALIST_CHANGED_PARAM	// used by callback function pfnCamListChangedCallback
{
	CAMERALIST_CHANGED_PARAM () : state (PS_CS_DISCONNECTED) { memset (&camInfo, 0, sizeof (PSCameraInfo)); }

	PSCameraInfo	camInfo;
	int				state;	// PS_CS_CONNECTED, PS_CS_DISCONNECTED
};

/////////////////////////////////////////////////////////////////////////////
// Helper structure for picture buffer

typedef	struct	tagDIBData
{
	HBITMAP		hBmp;
	LPVOID		vpBits;
}DIBData;

/////////////////////////////////////////////////////////////////////////////
// CSampleDlg dialog

class CSampleDlg : public CDialog
{
	DECLARE_DYNAMIC(CSampleDlg)

// Construction
public:
	CSampleDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSampleDlg)
	enum { IDD = IDD_SAMPLE_DIALOG };
	CStatic	m_PreviewLocation;
	CButton	m_btnRelease;
	CButton	m_btnPreview;
	CButton	m_btnPreviewClose;
	CButton	m_btnAEAF;
	CButton	m_btnConnect;
	CButton	m_btnDisconnect;
	CString	m_strInfo;
	CSliderCtrl m_sliderZoom;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSampleDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON			m_hIcon;
	CPropertySheet	m_PropSheet;
	CPropertyPage1	m_PropPage1;

	// Generated message map functions
	//{{AFX_MSG(CSampleDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
	afx_msg void OnDestroy();
	afx_msg void OnConnect();
	afx_msg void OnDisconnect();
	afx_msg void OnAEAF();
	afx_msg void OnPreview();
	afx_msg void OnPreviewClose();
	afx_msg void OnRelease();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	afx_msg LRESULT OnCameraInfo(WPARAM, LPARAM);
	afx_msg LRESULT OnGetPreviewFrame(WPARAM, LPARAM);
	afx_msg LRESULT OnZoomChanged(WPARAM, LPARAM);
	afx_msg LRESULT OnCamListChanged(WPARAM, LPARAM);
	afx_msg LRESULT OnPropertyListChanged(WPARAM, LPARAM);
	afx_msg LRESULT OnPropertyChanged(WPARAM, LPARAM);
	DECLARE_MESSAGE_MAP()

public:
	BOOL SetProperty (const int nPropID, CComboBox& cb);
private:
	void ResizeControls ();
	void UpdateControls ();
	void UpdateZoom ();
	void UpdateProperty (const int nPropID, CComboBox& cb);
	BOOL IsPropertySupported (const int nPropID);
	CString GetPath () const;
	void AddInformationMessage (const CString& str);
	BOOL CreateDIBBuffer ();
	void FreeDIBBuffer ();

	void CleanUp ();
	void CleanUpSession ();

	static void __stdcall pfnShootCompletedCallback (void* context, PSFileInfo* resFileId);
	static void __stdcall pfnDownloadCompletedCallback (void* context, PSFileId fileId);
	static void __stdcall pfnNewPreviewFrameCallback (void* context);
	static void __stdcall pfnCamListChangedCallback (void* context, PSCameraInfo* devInfo, int connectionState);
	static void __stdcall pfnPropertyListCallback (void* context);
	static void __stdcall pfnPropertyCallback (void* context, int prop);

	static SHOOT_COMPLETED_PARAM	s_ShootCompletedParam;
	static DOWNLOAD_COMPLETED_PARAM	s_DownloadCompletedParam;
	static PREVIEW_FRAME_PARAM		s_PreviewFrameParam;
	static CAMERALIST_CHANGED_PARAM	s_CameraListChangedParam;

private:
	BOOL	m_bConnected;
	BOOL	m_bPreviewEnabled;
	CString	m_strSavePath;

	DIBData				m_PreviewSurface;			// information of a picture
	CStatic*			m_pPreviewWnd;				// a window which shows the preview picture
	LONG				m_PreviewWidth;
	LONG				m_PreviewHeight;
	WORD				m_PreviewBitCount;

	PSCameraManagerHandle	m_CamManager;
	PSSessionHandle		m_Session;

	PSSubscriberHandle	m_hPreviewFrameEvent;
	PSSubscriberHandle	m_hCameraListEvent;
	PSSubscriberHandle	m_hPropertyListEvent;
	PSSubscriberHandle	m_hPropertyEvent;

	CStringList			m_lstAllMsgs;
	static const int	s_nMaxMsgsCount;

	CSize				m_sizeDlgMin;				// data for dialog resizing
	CSize				m_sizeDlgMargins;
	CSize				m_sizeDlgSpacings;
	int					m_nInfoHeight;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SAMPLEDLG_H__BC051E1F_C5E9_4480_B240_367499667ED1__INCLUDED_)
